@echo off
chcp 65001 >nul
color 0C
cls

:: Define pasta e arquivo de log
set "logdir=C:\logs"
set "logfile=%logdir%\AtualizacaoBIOS.log"

if not exist "%logdir%" mkdir "%logdir%"

echo ============================================================= >> "%logfile%"
echo [INICIO] %date% %time% - Execucao do script de atualizacao de BIOS >> "%logfile%"
echo ============================================================= >> "%logfile%"

:: Verifica se está sendo executado como administrador
net session >nul 2>&1
if %errorlevel% NEQ 0 (
    echo =============================================================
    echo   ERRO: Este script precisa ser executado como ADMINISTRADOR!
    echo   Clique com o botão direito no arquivo e escolha:
    echo   "Executar como administrador".
    echo =============================================================
    echo.
    pause
    exit /b
)


:: Alerta ao usuário
echo =============================================================
echo   ATENÇÃO: NÃO DESLIGUE OU REINICIE O EQUIPAMENTO DURANTE
echo   O PROCESSO DE ATUALIZAÇÃO DA BIOS!
echo =============================================================
echo.
pause

:: Muda para o diretório do script
cd /d "%~dp0"

:: Executa atualização
echo Atualizando BIOS...
echo [INFO] Iniciando atualizacao da BIOS em %date% %time% >> "%logfile%"
afuwinx64.EXE NTCBH004.I02 /P /B /N /X /K

if %errorlevel% NEQ 0 (
    echo [ERRO] Falha na atualizacao da BIOS! >> "%logfile%"
    echo.
    echo Houve uma falha na atualizacao. Verifique o log em %logfile%.
    pause
    exit /b
)

:: Fim
echo [SUCESSO] Atualizacao concluida em %date% %time% >> "%logfile%"
echo ============================================================= >> "%logfile%"
echo.
echo =============================================================
echo  ATENCAO: O sistema sera reiniciado em 10 segundos!
echo  TODOS os programas abertos serao FECHADOS automaticamente.
echo  Salve seu trabalho imediatamente.
echo =============================================================
echo.
timeout /t 10 >nul
shutdown /r /f /t 0
